<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/EtatOPC"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="EtatOPC"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"Liberation Serif";
  panose-1:2 2 6 3 5 4 5 2 3 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:16.0pt;
  font-family:"Times New Roman",serif;}
p.TableContents, li.TableContents, div.TableContents
  {
  margin:0cm;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 21.0cm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <div align="center">
            <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><tr><td width="50%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p style="line-height:115%;punctuation-wrap:simple;word-break: break-all"><span style="font-size:10.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/> - 
                           
                           
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="50%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p align="right" style="text-align:right;line-height:115%; punctuation-wrap:simple;word-break:break-all"><span style="font-size:10.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Date édition :
                           
                           
                           <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         </div>
         <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid PAGE_BREAK" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><td width="100%" valign="top" style="border:none;border-bottom: solid black 1.0pt;padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1">
                  <xsl:for-each select="$docbudg/Budget/Compte/@CompteDebit"><xsl:sort select="."></xsl:sort><xsl:variable name="codeBoucleTable" select="."></xsl:variable><xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid PAGE_BREAK" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm1" select="$docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/LigneOPC"/><thead>
                        <tr height="0" class="#tech# #fixWidths#"><td width="5%" style="border:none" rowspan="1" colspan="1"></td><td width="8%" style="border:none" rowspan="1" colspan="1"></td><td width="6%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="6%" style="border:none" rowspan="1" colspan="1"></td><td width="5%" style="border:none" rowspan="1" colspan="1"></td><td width="5%" style="border:none" rowspan="1" colspan="1"></td><td width="9%" style="border:none" rowspan="1" colspan="1"></td><td width="-2%" style="border:none" rowspan="1" colspan="1"></td><td width="7%" style="border:none" rowspan="1" colspan="1"></td><td width="8%" style="border:none" rowspan="1" colspan="1"></td><td width="6%" style="border:none" rowspan="1" colspan="1"></td><td width="12%" style="border:none" rowspan="1" colspan="1"></td><td width="18%" style="border:none" rowspan="1" colspan="1"></td></tr>
                        <tr><xsl:variable name="varOdm2" select="$varOdm1"/><td width="100%" colspan="14" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif"><span style="color:black">État des Ordres de Paiement<br clear="none" />
                                          du compte au débit</span></span></b><b><span style="font-size:12.0pt; font-family:&#34;Arial&#34;,sans-serif;color:black"><xsl:value-of select="distinct-values($codeBoucleTable)"/></span></b><b><span style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif;color:black"><br clear="none" /></span></b><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif; color:black">du <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/@DateDebut)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template>au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/@DateFin)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr>
                        <tr><td width="39%" colspan="6" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> - <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="12%" colspan="2" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1"> </td><td width="48%" colspan="6" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice :<xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr>
                        <xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@CodeBC = BA or $docbudg/EnteteComptable/Infos/Collectivite/@CodeBC = BR"><xsl:variable name="varOdm3" select="$varOdm1"/><tr><td width="100%" colspan="14" valign="top" style="border:none; border-bottom:solid black 1.0pt;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"></span><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">BA de <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="39%" colspan="6" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="12%" colspan="2" valign="top" rowspan="1" style="padding:0cm 0cm 0cm 0cm"></td><td height="1px" width="48%" colspan="6" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose>
                        <tr class="HBORDER"><xsl:variable name="varOdm4" select="$varOdm1"/><td width="100%" colspan="14" valign="top" style="border:none; border-bottom:solid black 1.0pt;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                              <p class="MsoNormal"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"></span></p>
                           </td></tr>
                        <tr><td width="5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Compte au débit</span></b></p>
                           </td><td width="8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Compte au crédit</span></b></p>
                           </td><td width="6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Numéro OPC</span></b></p>
                           </td><td width="7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Numéro écriture</span></b></p>
                           </td><td width="6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date écriture</span></b></p>
                           </td><td width="5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Objet</span></b></p>
                           </td><td width="5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Service</span></b></p>
                           </td><td width="7%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Créancier</span></b></p>
                           </td><td width="7%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Mode règlement</span></b></p>
                           </td><td width="8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Montant</span></b></p>
                           </td><td width="6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Pièce justificative</span></b></p>
                           </td><td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Mandat associé</span></b></p>
                           </td><td width="12%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date émargement</span></b></p>
                           </td></tr>
                     </thead><xsl:variable name="varOdm5" select="$varOdm1"/><xsl:variable name="varOdm6"><xsl:for-each select="$varOdm5"><xsl:sort select="./@NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content1"><xsl:value-of select="distinct-values($codeBoucleTable)"/></xsl:variable><xsl:variable name="className1" select="$ligne/@Format"/><xsl:variable name="className2">LIBELLE</xsl:variable><xsl:variable name="className3">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className1, ' ', $className2, ' ', $className3)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content1" /></xsl:call-template><xsl:variable name="content2"><xsl:value-of select="distinct-values($ligne/@CompteCredit)"/></xsl:variable><xsl:variable name="className4" select="$ligne/@Format"/><xsl:variable name="className5">LIBELLE</xsl:variable><xsl:variable name="className6">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className4, ' ', $className5, ' ', $className6)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content2" /></xsl:call-template><xsl:variable name="content3"><xsl:value-of select="distinct-values($ligne/@NumeroOPC)"/></xsl:variable><xsl:variable name="className7" select="$ligne/@Format"/><xsl:variable name="className8">LIBELLE</xsl:variable><xsl:variable name="className9">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className7, ' ', $className8, ' ', $className9)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">6%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content3" /></xsl:call-template><xsl:variable name="content4"><xsl:value-of select="distinct-values($ligne/@NumeroEcriture)"/></xsl:variable><xsl:variable name="className10" select="$ligne/@Format"/><xsl:variable name="className11">LIBELLE</xsl:variable><xsl:variable name="className12">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className10, ' ', $className11, ' ', $className12)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content4" /></xsl:call-template><xsl:variable name="content5"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/@DateEcriture)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className13" select="$ligne/@Format"/><xsl:variable name="className14">LIBELLE</xsl:variable><xsl:variable name="className15">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className13, ' ', $className14, ' ', $className15)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">6%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content5" /></xsl:call-template><xsl:variable name="content6"><xsl:value-of select="distinct-values($ligne/@Objet)"/></xsl:variable><xsl:variable name="className16" select="$ligne/@Format"/><xsl:variable name="className17">LIBELLE</xsl:variable><xsl:variable name="className18">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className16, ' ', $className17, ' ', $className18)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content6" /></xsl:call-template><xsl:variable name="content7"><xsl:value-of select="distinct-values($ligne/@Service)"/></xsl:variable><xsl:variable name="className19" select="$ligne/@Format"/><xsl:variable name="className20">LIBELLE</xsl:variable><xsl:variable name="className21">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className19, ' ', $className20, ' ', $className21)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content7" /></xsl:call-template><xsl:variable name="content8"><xsl:value-of select="distinct-values($ligne/@NomCreancier)"/> - <xsl:value-of select="distinct-values($ligne/@AdresseCreancier)"/></xsl:variable><xsl:variable name="className22" select="$ligne/@Format"/><xsl:variable name="className23">LIBELLE</xsl:variable><xsl:variable name="className24">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className22, ' ', $className23, ' ', $className24)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content8" /></xsl:call-template><xsl:variable name="content9"><xsl:value-of select="distinct-values($ligne/@ModeReglement)"/> - <xsl:value-of select="distinct-values($ligne/@RefCompteBancaire)"/></xsl:variable><xsl:variable name="className25" select="$ligne/@Format"/><xsl:variable name="className26">LIBELLE</xsl:variable><xsl:variable name="className27">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className25, ' ', $className26, ' ', $className27)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content9" /></xsl:call-template><xsl:variable name="content10"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@Montant"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className28" select="$ligne/@Format"/><xsl:variable name="className29">DECIMAL</xsl:variable><xsl:variable name="className30">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className28, ' ', $className29, ' ', $className30)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content10" /></xsl:call-template><xsl:variable name="content11"><xsl:value-of select="distinct-values($ligne/@ReferencePJ)"/></xsl:variable><xsl:variable name="className31" select="$ligne/@Format"/><xsl:variable name="className32">LIBELLE</xsl:variable><xsl:variable name="className33">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className31, ' ', $className32, ' ', $className33)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">6%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content11" /></xsl:call-template><xsl:variable name="content12"><xsl:for-each select="$ligne/Emargement/@NumMandatEmarge"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_13" select="."></xsl:variable><xsl:variable name="blocLignes_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_13" select="$ligne/Emargement[(./@NumMandatEmarge=$codeBoucleBloc_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_13)]"/><xsl:if test="$blocLignes_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_13"> <xsl:value-of select="distinct-values($codeBoucleBloc_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_13)"/> <br /></xsl:if></xsl:for-each></xsl:variable><xsl:variable name="className34" select="$ligne/@Format"/><xsl:variable name="className35">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className34, ' ', $className35)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content12" /></xsl:call-template><xsl:variable name="content13"><xsl:for-each select="$ligne/Emargement/@NumMandatEmarge"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_14" select="."></xsl:variable><xsl:variable name="blocLignes_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_14" select="$ligne/Emargement[(./@NumMandatEmarge=$codeBoucleBloc_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_14)]"/><xsl:if test="$blocLignes_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_14">  <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DOPC_BU_CPT_LOPC_Em_NumMandatEmarge_14/@DateEmargement)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template> <br /></xsl:if></xsl:for-each></xsl:variable><xsl:variable name="className36" select="$ligne/@Format"/><xsl:variable name="className37">DECIMAL</xsl:variable><xsl:variable name="className38">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className36, ' ', $className37, ' ', $className38)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content13" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm7"><xsl:choose><xsl:when test="count($varOdm6/*) = 0"><tr class=" #tech#"><td height="1px" width="5%" valign="top" rowspan="1" colspan="1" style=" border-top:hidden;padding: 0cm 0cm 1.5pt 0cm;; border-bottom: solid black 1.0pt; border-left:solid black 1.0pt; border-right:solid black 1.0pt"></td><td height="1px" width="8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="5%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="5%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="8%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="6%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="12%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom: solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm6"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm7/xhtml:tr"></xsl:with-param></xsl:call-template><tr class="DOPC.BU.CPT.TC.Format [ DECIMAL [ BORDURE" style="height:35.9pt"><xsl:variable name="varOdm8" select="$varOdm1"/><xsl:variable name="content14"><xsl:value-of select="distinct-values($docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/TotalCompte/@Libelle)"/></xsl:variable><xsl:variable name="className39" select="$docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/TotalCompte/@Format"/><xsl:variable name="className40">DECIMAL</xsl:variable><xsl:variable name="className41">BORDURE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className39, ' ', $className40, ' ', $className41)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">10</xsl:with-param><xsl:with-param name="width">60%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content14" /></xsl:call-template><xsl:variable name="content15"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/TotalCompte/@Montant"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className42" select="$docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/TotalCompte/@Format"/><xsl:variable name="className43">DECIMAL</xsl:variable><xsl:variable name="className44">BORDURE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className42, ' ', $className43, ' ', $className44)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content15" /></xsl:call-template><xsl:variable name="content16"> </xsl:variable><xsl:variable name="className45" select="$docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/TotalCompte/@Format"/><xsl:variable name="className46">DECIMAL</xsl:variable><xsl:variable name="className47">BORDURE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className45, ' ', $className46, ' ', $className47)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">6%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content16" /></xsl:call-template><xsl:variable name="content17"> </xsl:variable><xsl:variable name="className48" select="$docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/TotalCompte/@Format"/><xsl:variable name="className49">DECIMAL</xsl:variable><xsl:variable name="className50">BORDURE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className48, ' ', $className49, ' ', $className50)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content17" /></xsl:call-template><xsl:variable name="content18"> </xsl:variable><xsl:variable name="className51" select="$docbudg/Budget/Compte[(./@CompteDebit=$codeBoucleTable)]/TotalCompte/@Format"/><xsl:variable name="className52">DECIMAL</xsl:variable><xsl:variable name="className53">BORDURE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className51, ' ', $className52, ' ', $className53)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content18" /></xsl:call-template></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template></xsl:for-each>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="margin-bottom:10.0pt;line-height:115%"><span lang="EN-US" style="line-height:115%"> </span></p>
         <p class="MsoNormal" style="margin-bottom:10.0pt;line-height:115%;page-break-before:always"><span lang="EN-US" style="line-height:115%"> </span></p>
         <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">État des Ordres de Paiement</span></b></p>
               </td></tr><tr><td width="50%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> - <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="50%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice :<xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@CodeBC = BA or $docbudg/EnteteComptable/Infos/Collectivite/@CodeBC = BR"><xsl:variable name="varOdm9" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="50%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"></span><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">BA de <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></span></p></td><td width="50%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="50%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="50%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><tr><td width="100%" colspan="2" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1">
                  <xsl:variable name="varOdmTmpTab5"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr height="0" class="#tech# #fixWidths#"><td width="4.6%" style="border:none" rowspan="1" colspan="1"></td><td width="4.6%" style="border:none" rowspan="1" colspan="1"></td><td width="4.6%" style="border:none" rowspan="1" colspan="1"></td><td width="4.7%" style="border:none" rowspan="1" colspan="1"></td><td width="4.7%" style="border:none" rowspan="1" colspan="1"></td><td width="3.6%" style="border:none" rowspan="1" colspan="1"></td><td width="4.6%" style="border:none" rowspan="1" colspan="1"></td><td width="5.6%" style="border:none" rowspan="1" colspan="1"></td><td width="5.7%" style="border:none" rowspan="1" colspan="1"></td><td width="16.9%" style="border:none" rowspan="1" colspan="1"></td><td width="6.4%" style="border:none" rowspan="1" colspan="1"></td><td width="16.9%" style="border:none" rowspan="1" colspan="1"></td><td width="16.9%" style="border:none" rowspan="1" colspan="1"></td></tr><tr><td width="4.6%" style="border:solid black 1.0pt;padding: 0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Compte au débit</span></b></p>
                        </td><td width="4.6%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Compte au crédit</span></b></p>
                        </td><td width="4.6%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Numéro OPC</span></b></p>
                        </td><td width="4.7%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Numéro écriture</span></b></p>
                        </td><td width="4.7%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date écriture</span></b></p>
                        </td><td width="3.6%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Objet</span></b></p>
                        </td><td width="4.6%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Service</span></b></p>
                        </td><td width="5.6%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Créancier</span></b></p>
                        </td><td width="5.7%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Mode règlement</span></b></p>
                        </td><td width="16.9%" style="border:solid black 1.0pt; border-left:none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Montant</span></b></p>
                        </td><td width="6.4%" style="border:solid black 1.0pt;border-left: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Pièce justificative</span></b></p>
                        </td><td width="16.9%" style="border:solid black 1.0pt; border-left:none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Mandat associé</span></b></p>
                        </td><td width="16.9%" style="border:solid black 1.0pt; border-left:none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date émargement</span></b></p>
                        </td></tr><tr><xsl:variable name="varOdm10" select="$docbudg/Budget/Compte/LigneOPC"/><xsl:variable name="content19"><xsl:value-of select="distinct-values($docbudg/Budget/TotalBudget/@Libelle)"/></xsl:variable><xsl:variable name="className54" select="$docbudg/Budget/TotalBudget/@Format"/><xsl:variable name="className55">LIBELLE</xsl:variable><xsl:variable name="className56">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className54, ' ', $className55, ' ', $className56)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">9</xsl:with-param><xsl:with-param name="width">42.8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content19" /></xsl:call-template><xsl:variable name="content20"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/TotalBudget/@Montant"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className57" select="$docbudg/Budget/TotalBudget/@Format"/><xsl:variable name="className58">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className57, ' ', $className58)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">16.9%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content20" /></xsl:call-template><xsl:variable name="content21">
                           <span></span>
                        </xsl:variable><xsl:variable name="className59" select="$docbudg/Budget/TotalBudget/@Format"/><xsl:variable name="className60">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className59, ' ', $className60)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">6.4%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content21" /></xsl:call-template><xsl:variable name="content22">
                           <span></span>
                        </xsl:variable><xsl:variable name="className61" select="$docbudg/Budget/TotalBudget/@Format"/><xsl:variable name="className62">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className61, ' ', $className62)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">16.9%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content22" /></xsl:call-template><xsl:variable name="content23">
                           <span></span>
                        </xsl:variable><xsl:variable name="className63" select="$docbudg/Budget/TotalBudget/@Format"/><xsl:variable name="className64">LIBELLE</xsl:variable><xsl:variable name="className65">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className63, ' ', $className64, ' ', $className65)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">16.9%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content23" /></xsl:call-template></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param></xsl:call-template>
               </td></tr><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p><p align="center" style="text-align:center"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">A <xsl:value-of select="distinct-values($docbudg/Budget/Validation/@Ville)"/> le <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/Budget/Validation/@DateValidation)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p><p align="center" style="text-align:center"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Le comptable public : <xsl:value-of select="distinct-values($docbudg/Budget/Validation/@Comptable)"/></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"> </p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>